'''
This program fades the LED up and down using PWM
'''

import time
import board
import pwmio

# Setup the LED
led = pwmio.PWMOut(board.GP16, frequency=5000, duty_cycle=0)

while True:
    # Fade UP: Count from 0 to 65535 by steps of 500
    for i in range(0, 65535, 500):
        led.duty_cycle = i
        time.sleep(0.01)

    # Fade DOWN: Count from 65535 down to 0 by steps of -500
    for i in range(65535, 0, -500):
        led.duty_cycle = i
        time.sleep(0.01)