'''
This program lets the button control the LED
'''

import board  # Tells the code about the specific pins on the Pico
from digitalio import DigitalInOut, Direction, Pull  # Tools for basic On/Off control
import time   # Tools for pausing and waiting

# 1. SETUP THE OUTPUT (The LED)
led = DigitalInOut(board.GP16)
led.direction = Direction.OUTPUT

# 2. SETUP THE INPUT (The Button)
# We use GP22 for the button
button = DigitalInOut(board.GP22)
button.direction = Direction.INPUT

# "Pull.UP" is a specific internal resistor setup.
# It connects the pin to 3.3V internally.
# Default State (Not Pressed) = HIGH (1) / 3.3V
# Pressed State (Connected to Ground) = LOW (0) / 0V
button.pull = Pull.UP

# 3. THE MAIN LOOP
while True:
    # Check if the button is pressed.
    # Because we use Pull.UP, pressing the button connects it to Ground (0).
    # So, 0 means "Pressed".
    if button.value == 0:
        led.value = 1  # Turn LED ON
    else:
        led.value = 0  # Turn LED OFF