'''
This program flashes the LED on and off
'''

import board  # Tells the code about the Pico's specific pins
from digitalio import DigitalInOut, Direction  # Tools for On/Off control
import time   # Tools to pause the code

# 1. HARDWARE SETUP
# Create a connection to the pin labeled GP16
led = DigitalInOut(board.GP16)

# Set the pin direction to OUTPUT
# OUTPUT = We send voltage OUT to the LED (Talking)
# INPUT  = We read voltage coming IN from a button (Listening)
led.direction = Direction.OUTPUT

# 2. THE MAIN LOOP
# This runs forever. The indentation tells Python what belongs inside the loop.
while True:
    # Turn the LED ON
    # We send 3.3 Volts to the pin.
    led.value = True
    
    # Wait for 0.5 seconds
    # The light stays ON during this pause.
    time.sleep(0.5)

    # Turn the LED OFF
    # We cut the power (0 Volts).
    led.value = False

    # Wait for 0.5 seconds
    # The light stays OFF during this pause.
    time.sleep(0.5)