'''
This program allows the potentiometer (knob) to control the LED brightness
'''

import board
import pwmio            # Required for "fading" output
from analogio import AnalogIn  # Required for reading the knob
import time

# 1. SETUP THE LED (Output)
# We change from DigitalInOut to PWMOut.
# PWM turns the power on/off very fast to fake "brightness."
led = pwmio.PWMOut(board.GP16, frequency=5000, duty_cycle=0)

# 2. SETUP THE POTENTIOMETER (Input)
# This must be on an Analog pin (GP26, GP27, or GP28).
pot = AnalogIn(board.GP26)

while True:
    # 3. THE LOGIC
    # The Potentiometer gives a value between 0 and 65535.
    # The LED Duty Cycle expects a value between 0 and 65535.
    
    # We can just match them directly!
    led.duty_cycle = pot.value
    
    # Optional: Short delay to keep the loop stable
    time.sleep(0.01)
